/************************************************************************
 * NAME:	init.c
 *
 * DESCR:	Routines to initialize the COCO fs.
 *
 * NOTES:	
 ************************************************************************/

#include "coco.h"

/************************************************************************
 * NAME:	coco_init()
 *
 * DESCR:	Initialize the coco data structure.
 *
 * ARGS:	cocofs is filled in
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
coco_init(struct cocofs *cocofs, 
	  cocodevice device, 
	  cocoreadfn readblkfn, 
	  cocowritefn writeblkfn)
{
    cocofs->device = device;
    cocofs->preadsec = readblkfn;
    cocofs->pwritesec = writeblkfn;

    coco_dir_init(&cocofs->dirbuf);

    return(TRUE);
}

int
coco_settings(struct cocofs	*cocofs,
	      int		startsec,	/* physical start sect	*/
	      int		openfiles)	/* max open files	*/
{
    cocofs->startsec = startsec;

    coco_dir_read(cocofs);
    coco_fat_read(cocofs);

    coco_fileio_init(cocofs,openfiles);

    return(TRUE);
}


/************************************************************************
 * NAME:	coco_cleanup()
 *
 * DESCR:	Frees any allocated structures.  This should really "flush"
 *		too.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
coco_cleanup(struct cocofs *cocofs)
{
    coco_dir_cleanup(&cocofs->dirbuf);
    coco_fileio_cleanup(cocofs);

    return(TRUE);
}



